package h.com.serialapp.activity.fragment

import android.os.Bundle
import android.os.Handler
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.AdapterView
import android.widget.ArrayAdapter
import h.com.serialapp.R
import h.com.serialapp.adapter.LogAdapter
import h.com.serialportapi.comn.CommPacket
import h.com.serialportapi.comn.Packet
import h.com.serialportapi.comn.SerialReadThread
import h.com.serialportapi.comn.message.ICMessage
import h.com.serialportapi.comn.message.IMessage
import h.com.serialportapi.comn.message.LogManager
import kotlinx.android.synthetic.main.view_ultralight.view.*

/**
 * Created by hxd on 2018/10/21.
 */
class Uitralight_C : BasesFragment(), AdapterView.OnItemSelectedListener {
    lateinit var views: View
    var logAdapter: LogAdapter = LogAdapter()

    override fun add(message: IMessage) {
        logAdapter.add(message)
        views.lv_log.setSelection(logAdapter.count - 1)
    }

    var handler = Handler(Handler.Callback { msg ->
        when (msg.what) {
            1 -> {
                views.et_tag_type.setText(icObject.tag_Type)
                views.et_sak.setText(icObject.sak)
                views.et_uid_number.setText(icObject.uiD_number)
            }
        }
        false
    })

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        val view = inflater!!.inflate(R.layout.view_ultralight, null)
        views = view
        view.lv_log.adapter = logAdapter
        views.btn_clear_log.setOnClickListener {
            LogManager.instance().clear()
            logAdapter.notifyDataSetChanged()
        }
        initView()
        return view
    }

    /*  override fun onCreateView(inflater: LayoutInflater?, container: ViewGroup?, savedInstanceState: Bundle?): View {
       val view = inflater!!.inflate(R.layout.view_ultralight, null)
       views = view
       initView()
       return view
   }*/

    lateinit var icObject: ICMessage
    lateinit var current: String
    lateinit var array: Array<String>
    fun initView() {
        array = resources.getStringArray(R.array.block_addr)
        views.spinner_page_addr.adapter = ArrayAdapter<String>(activity, R.layout.spinner_default_item, array)
        views.spinner_page_addr.onItemSelectedListener=this
        var idle = byteArrayOf(10, 26)
        var all = byteArrayOf(10, 52)
        views.bt_activityIDLE.setOnClickListener {
            CommPacket.PiccActivate(Packet(idle, 50, 2, 22).sendData, SerialReadThread.ActivityListener { message ->
                icObject = message
                handler.sendEmptyMessage(1)
            })
        }
        views.bt_activityALL.setOnClickListener {
            CommPacket.PiccActivate(Packet(all, 50, 2, 22).sendData, SerialReadThread.ActivityListener { message ->
                icObject = message
                handler.sendEmptyMessage(1)
            })
        }
        views.bt_apduChannel.setOnClickListener {
            CommPacket.PiccTransfer(views.et_apdu.text.toString(), SerialReadThread.ReaderListener { message ->
                Log.i("CommPaket PiccTransfer", message)
//                icObject = message
//                handler.sendEmptyMessage(1)
            })
        }
        views.bt_authenticate.setOnClickListener {
            CommPacket.PiccULAuth(views.et_key.text.toString(), SerialReadThread.ReaderListener { })
        }
        views.bt_changeKey.setOnClickListener { CommPacket.PiccULAuth(views.et_newKey.text.toString(), SerialReadThread.ReaderListener { }) }
        views.bt_readPage.setOnClickListener { CommPacket.PiccRead(addValue, SerialReadThread.ReaderListener { msg -> Log.i("CommPaket PiccRead", msg) }) }
        views.bt_writePage.setOnClickListener { CommPacket.PiccULWrite(views.et_writePage.text.toString(), addValue, SerialReadThread.ReaderListener { }) }
    }

    var addValue: String = "0"
    override fun onItemSelected(parent: AdapterView<*>, view: View, position: Int, id: Long) {

        // Spinner 选择监听
        when (parent.id) {
            R.id.spinner_page_addr -> {
                addValue = array.get(position)
            }
        }
    }

    override fun onNothingSelected(parent: AdapterView<*>) {
        // 空实现
    }
}